from collections import defaultdict

def solve():
    n = int(input())
    pts = [tuple(map(int, input().split())) for _ in range(n)]

    # (x, y, t) -> broj trkaca koji stignu tu u tom trenutku
    events = defaultdict(int)

    # 6 tipova ukrštanja:
    # N-J, E-W, N-E, N-W, S-E, S-W

    # 1) N-J i E-W rade se po linijama
    by_x = defaultdict(list)
    by_y = defaultdict(list)

    for x, y in pts:
        by_x[x].append(y)
        by_y[y].append(x)

    # N-J
    for x, ys in by_x.items():
        ys.sort()
        for i in range(len(ys)):
            for j in range(i+1, len(ys)):
                y1, y2 = ys[i], ys[j]
                d = y2 - y1
                if d % 2: continue
                t = d // 2
                yM = y1 + t
                events[(x, yM, t)] += 2

    # E-W
    for y, xs in by_y.items():
        xs.sort()
        for i in range(len(xs)):
            for j in range(i+1, len(xs)):
                x1, x2 = xs[i], xs[j]
                d = x2 - x1
                if d % 2: continue
                t = d // 2
                xM = x1 + t
                events[(xM, y, t)] += 2

    # 2) Diagonalna ukrštanja (4 vrste)
    for i in range(n):
        x1, y1 = pts[i]
        for j in range(i+1, n):
            x2, y2 = pts[j]

            dx = x2 - x1
            dy = y2 - y1

            # N iz (x1,y1) i E iz (x2,y2):
            # (x1, y1+t) == (x2+t, y2)
            # t = y2 - y1,   and x1 = x2 + t
            t = y2 - y1
            if t >= 0 and x1 == x2 + t:
                events[(x1, y1 + t, t)] += 2

            # N iz (x1,y1) i W iz (x2,y2):
            # (x1, y1+t) == (x2-t, y2)
            # t = y2 - y1,   x1 = x2 - t
            t = y2 - y1
            if t >= 0 and x1 == x2 - t:
                events[(x1, y1 + t, t)] += 2

            # S iz (x1,y1) i E iz (x2,y2):
            # (x1, y1-t) == (x2+t, y2)
            # t = y1 - y2,  x1 = x2 + t
            t = y1 - y2
            if t >= 0 and x1 == x2 + t:
                events[(x1, y1 - t, t)] += 2

            # S iz (x1,y1) i W iz (x2,y2):
            # (x1, y1-t) == (x2-t, y2)
            # t = y1 - y2,  x1 = x2 - t
            t = y1 - y2
            if t >= 0 and x1 == x2 - t:
                events[(x1, y1 - t, t)] += 2

    # Saberi pozdrave
    total = 0
    for k in events.values():
        total += k * (k - 1) // 2

    print(total+1)


solve()